import { Request, Response, NextFunction } from 'express';
import { subscriptionService } from '@/modules/subscriptions/service';

export function checkFeature(featureKey: string) {
  return async (req: any, res: Response, next: NextFunction) => {
    const userId = req.user?.id;
    if (!userId) {
      return res.status(401).json({ success: false, error: 'Unauthorized' });
    }
    const features = await subscriptionService.getAvailableFeatures(userId);
    if (!features.includes(featureKey)) {
      return res.status(403).json({ success: false, error: 'Feature not available for your plan' });
    }
    next();
  };
} 